/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.placement;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.createmod.ponder.config.CClient;
import net.createmod.ponder.enums.PonderConfig;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.class_1041;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix4f;

public class PlacementClient {
    static final LerpedFloat angle = LerpedFloat.angular().chase(0.0, 0.25, LerpedFloat.Chaser.EXP);
    @Nullable
    static class_2338 target = null;
    @Nullable
    static class_2338 lastTarget = null;
    static int animationTick = 0;

    public static void tick() {
        PlacementClient.setTarget(null);
        PlacementClient.checkHelpers();
        if (target == null) {
            if (animationTick > 0) {
                animationTick = Math.max(animationTick - 2, 0);
            }
            return;
        }
        if (animationTick < 10) {
            ++animationTick;
        }
    }

    private static void checkHelpers() {
        class_310 mc = class_310.method_1551();
        class_638 world = mc.field_1687;
        if (world == null) {
            return;
        }
        class_1268[] class_1268Array = mc.field_1765;
        if (!(class_1268Array instanceof class_3965)) {
            return;
        }
        class_3965 ray = (class_3965)class_1268Array;
        if (mc.field_1724 == null) {
            return;
        }
        if (mc.field_1724.method_5715()) {
            return;
        }
        for (class_1268 hand : class_1268.values()) {
            class_1799 heldItem = mc.field_1724.method_5998(hand);
            ArrayList<IPlacementHelper> filteredForHeldItem = new ArrayList<IPlacementHelper>();
            for (IPlacementHelper helper : PlacementHelpers.getHelpersView()) {
                if (!helper.matchesItem(heldItem)) continue;
                filteredForHeldItem.add(helper);
            }
            if (filteredForHeldItem.isEmpty()) continue;
            class_2338 pos = ray.method_17777();
            class_2680 state = world.method_8320(pos);
            ArrayList<IPlacementHelper> filteredForState = new ArrayList<IPlacementHelper>();
            for (IPlacementHelper helper : filteredForHeldItem) {
                if (!helper.matchesState(state)) continue;
                filteredForState.add(helper);
            }
            if (filteredForState.isEmpty()) continue;
            boolean atLeastOneMatch = false;
            for (IPlacementHelper h : filteredForState) {
                PlacementOffset offset = h.getOffset((class_1657)mc.field_1724, (class_1937)world, state, pos, ray, heldItem);
                if (!offset.isSuccessful()) continue;
                h.renderAt(pos, state, ray, offset);
                PlacementClient.setTarget(offset.getBlockPos());
                atLeastOneMatch = true;
                break;
            }
            if (!atLeastOneMatch) continue;
            return;
        }
    }

    static void setTarget(@Nullable class_2338 target) {
        PlacementClient.target = target;
        if (target == null) {
            return;
        }
        if (lastTarget == null) {
            lastTarget = target;
            return;
        }
        if (!lastTarget.equals((Object)target)) {
            lastTarget = target;
        }
    }

    public static void onRenderCrosshairOverlay(class_1041 window, class_332 graphics, float partialTicks) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player != null && animationTick > 0) {
            float screenY = (float)window.method_4502() / 2.0f;
            float screenX = (float)window.method_4486() / 2.0f;
            float progress = PlacementClient.getCurrentAlpha();
            PlacementClient.drawDirectionIndicator(graphics, partialTicks, screenX, screenY, progress);
        }
    }

    public static float getCurrentAlpha() {
        return Math.min((float)animationTick / 10.0f, 1.0f);
    }

    private static void drawDirectionIndicator(class_332 graphics, float partialTicks, float centerX, float centerY, float progress) {
        float r = 0.8f;
        float g = 0.8f;
        float b = 0.8f;
        float a = progress * progress;
        class_243 projTarget = VecHelper.projectToPlayerView(VecHelper.getCenterOf((class_2382)lastTarget), partialTicks);
        class_243 target = new class_243(projTarget.field_1352, projTarget.field_1351, 0.0);
        if (projTarget.field_1350 > 0.0) {
            target = target.method_22882();
        }
        class_243 norm = target.method_1029();
        class_243 ref = new class_243(0.0, 1.0, 0.0);
        float targetAngle = AngleHelper.deg(Math.acos(norm.method_1026(ref)));
        if (norm.field_1352 < 0.0) {
            targetAngle = 360.0f - targetAngle;
        }
        if (animationTick < 10) {
            angle.setValue(targetAngle);
        }
        angle.chase(targetAngle, 0.25, LerpedFloat.Chaser.EXP);
        angle.tickChaser();
        float snapSize = 22.5f;
        float snappedAngle = snapSize * (float)Math.round(angle.getValue(0.0f) / snapSize) % 360.0f;
        float length = 10.0f;
        CClient.PlacementIndicatorSetting mode = (CClient.PlacementIndicatorSetting)((Object)PonderConfig.Client().placementIndicator.get());
        class_4587 poseStack = graphics.method_51448();
        if (mode == CClient.PlacementIndicatorSetting.TRIANGLE) {
            PlacementClient.fadedArrow(poseStack, centerX, centerY, r, g, b, a, length, snappedAngle);
        } else if (mode == CClient.PlacementIndicatorSetting.TEXTURE) {
            PlacementClient.textured(poseStack, centerX, centerY, a, snappedAngle);
        }
    }

    private static void fadedArrow(class_4587 ms, float centerX, float centerY, float r, float g, float b, float a, float length, float snappedAngle) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        ms.method_22903();
        ms.method_46416(centerX, centerY, 5.0f);
        ms.method_22907(class_7833.field_40718.rotationDegrees(angle.getValue(0.0f)));
        double scale = (Double)PonderConfig.Client().indicatorScale.get();
        ms.method_22905((float)scale, (float)scale, 1.0f);
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        Matrix4f mat = ms.method_23760().method_23761();
        bufferbuilder.method_22918(mat, 0.0f, -(10.0f + length), 0.0f).method_22915(r, g, b, a).method_1344();
        bufferbuilder.method_22918(mat, -9.0f, -3.0f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        bufferbuilder.method_22918(mat, -6.0f, -6.0f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        bufferbuilder.method_22918(mat, -3.0f, -8.0f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        bufferbuilder.method_22918(mat, 0.0f, -8.5f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        bufferbuilder.method_22918(mat, 3.0f, -8.0f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        bufferbuilder.method_22918(mat, 6.0f, -6.0f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        bufferbuilder.method_22918(mat, 9.0f, -3.0f, 0.0f).method_22915(r, g, b, 0.0f).method_1344();
        tesselator.method_1350();
        RenderSystem.disableBlend();
        ms.method_22909();
    }

    public static void textured(class_4587 ms, float centerX, float centerY, float alpha, float snappedAngle) {
        PonderGuiTextures.PLACEMENT_INDICATOR_SHEET.bind();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34541);
        ms.method_22903();
        ms.method_46416(centerX, centerY, 50.0f);
        float scale = ((Double)PonderConfig.Client().indicatorScale.get()).floatValue() * 0.75f;
        ms.method_22905(scale, scale, 1.0f);
        ms.method_22905(12.0f, 12.0f, 1.0f);
        float index = snappedAngle / 22.5f;
        float tex_size = 0.0625f;
        float tx = 0.0f;
        float ty = index * tex_size;
        float tw = 1.0f;
        float th = tex_size;
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        Matrix4f mat = ms.method_23760().method_23761();
        buffer.method_22918(mat, -1.0f, -1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(tx, ty).method_1344();
        buffer.method_22918(mat, -1.0f, 1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(tx, ty + th).method_1344();
        buffer.method_22918(mat, 1.0f, 1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(tx + tw, ty + th).method_1344();
        buffer.method_22918(mat, 1.0f, -1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(tx + tw, ty).method_1344();
        tesselator.method_1350();
        RenderSystem.disableBlend();
        ms.method_22909();
    }
}

